<?php
session_start(); // Khởi tạo phiên làm việc

// Hàm cập nhật số lượng sản phẩm trong giỏ hàng
function updateCartQuantity($productId, $quantity) {
    if(isset($_SESSION['cart'][$productId])) {
        $_SESSION['cart'][$productId]['quantity'] = $quantity;
    }
}

// Hàm lấy thông tin giỏ hàng từ phiên làm việc
function getCart() {
    return isset($_SESSION['cart']) ? $_SESSION['cart'] : [];
}

// Lưu thông tin giỏ hàng vào phiên làm việc khi người dùng cập nhật số lượng
if(isset($_POST['update_cart'])) {
    foreach($_POST['quantity'] as $productId => $quantity) {
        updateCartQuantity($productId, $quantity);
    }
}

// Lấy thông tin giỏ hàng từ phiên làm việc
$cart = getCart();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Giỏ hàng</title>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css" integrity="sha512-xh6O/CkQoPOWDdYTDqeRdPCVd1SpvCA9XXcUnZS2FmJNp1coAFzvtCN9BmamE+4aHK8yyUHUSCcJHgXloTyT2A==" crossorigin="anonymous" referrerpolicy="no-referrer">
    <script src="https://kit.fontawesome.com/41e46c9144.js" crossorigin="anonymous"></script>
    <link rel="stylesheet" href="/BTLWEB/css/home.css">
    <link rel="stylesheet" href="/BTLWEB/css/shopping_cart.css">
    <style>
        .custom-button {
            background-color: #007bff;
            color: #ffffff;
            border: none;
            padding: 10px 20px;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        .custom-button:hover {
            background-color: #0056b3;
        }
        .table {
            width: 100%;
            border-collapse: collapse;
        }
        .table th, .table td {
            border: 1px solid #dddddd;
            padding: 8px;
            text-align: center;
        }
        .table th {
            background-color: #f2f2f2;
        }
        .text-left {
            text-align: left;
        }
        .quantity-buttons {
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .quantity-buttons button {
            background-color: transparent;
            border: none;
            cursor: pointer;
            font-size: 18px;
        }
        a {
            text-decoration: none;
            color: black;
            font-weight: 540;
        }
        a:hover {
            color: #71bec2 !important;
        }
    </style>
</head>
<body>
    <!-- HEADER -->
    <?php
        include "../authen/signin_submit.php";
        if (isset($_SESSION["email"])&& isset($_SESSION['role']) && $_SESSION['role'] == '0') {
        // user đã đăng nhập thành công
            echo require "header_user.php";
        } else {
        // Chưa đăng nhập
            echo require "header.php";
                }
    ?>
    <!-- HEADER END -->
    <main>
        <section class="main-cart-page main-container col1-layout">
            <div class="main container cartpcstyle">
                <div class="wrap_background_aside margin-bottom-40">
                    <div class="header-cart">
                        <div class="title-block-page">
                            <h1 class="title_cart">
                                <span>Giỏ hàng của bạn</span>
                            </h1>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-9 col-md-12 col-sm-12 col-xs-12 col-12">
                            <div class="clearfix"></div>
                            <div class="cart-page d-xl-block">
                                <div class="drawer__inner">
                                    <div class="CartPageContainer">
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th style="width: 100%;">Thông tin sản phẩm</th>
                                                    <th style="width: 5%;">Đơn giá</th>
                                                    <th style="width: 0%;">Số lượng</th>
                                                    <th style="width: 30%;">Thành tiền</th>
                                                    <th style="width: 10%;">Xóa</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                require_once('../database/dbhelper.php');
                                                $sql = "SELECT product_thumbnail, product_title, product_id, price, quantity, total_money FROM order_details";
                                                $orderList = executeResult($sql);
                                                if ($orderList) {
                                                    foreach ($orderList as $order) {
                                                        echo "<tr>";
                                                        echo "<td class='text-left' style='text-align: left; display: flex;>";
                                                        echo "<a href='productdetail.php?id=" . $order['product_id'] . "' title='" . $order['product_title'] . "' style='margin-right: 10px;'><img src='" . $order['product_thumbnail'] . "' style='width: 50px;' alt='" . $order['product_title'] . "'></a>";
                                                        echo "<a style='margin-left: 10px' href='productdetail.php?id=" . $order['product_id'] . "' title='" . $order['product_title'] . "'>" . $order['product_title'] . "</a>";
                                                        echo "</td>";
                                                        echo "<td class='text-center'>" . number_format($order['price'], 0, ',', '.') . "₫</td>";                                   
                                                        echo "<td class='text-center'>";
                                                        echo "<div class='quantity-buttons'>";
                                                        echo "<button style='margin-left: 10px; 'margin-right: 10px' onclick='decreaseQuantity(" . $order['product_id'] . ", " . $order['price'] . ")'>-</button>";
                                                        echo "<input type='text' id='quantity_" . $order['product_id'] . "' value='" . $order['quantity'] . "' style='width: 30px; text-align: center;' onchange='updateTotal(" . $order['product_id'] . ", " . $order['price'] . ", this.value)'>";
                                                        echo "<button style='margin-right: 10px;margin-left: 10px' onclick='increaseQuantity(" . $order['product_id'] . ", " . $order['price'] . ")'>+</button>";
                                                        echo "</div>";
                                                        echo "</td>";
                                                        echo "<td class='text-center' id='total_" . $order['product_id'] . "'>" . number_format($order['total_money'], 0, ',', '.') . "₫</td>";
                                                        echo "<td class='text-center'><button style='margin-left: 10px' onclick='confirmDelete(" . $order['product_id'] . ")'><i class='fas fa-trash'></i></button></td>";
                                                        echo "</tr>";
                                                    }
                                                } else {
                                                    echo "<tr><td colspan='5' class='text-center'>Không có sản phẩm trong giỏ hàng.</td></tr>";
                                                }
                                                $total_price = 0;
                                                if ($orderList) {
                                                    foreach ($orderList as $order) {
                                                        $total_price += $order['total_money'];
                                                    }
                                                }
                                                ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>  
                        <div class="ajaxcart__footer ajaxcart__footer--fixed cart-footer">
                            <div class="row">
                                <div class="col-lg-8 col-12">
                                    <div style="margin-top: 50px;">
                                        <a class="btn-proceed-checkout btn-checkouts chuxanh" title="Tiếp tục mua hàng" href="home.php">Tiếp tục mua hàng</a>                     
                                    </div>
                                </div>
                                <div class="col-lg-4 col-12">
                                    <div class="ajaxcart__subtotal">
                                        <div class="">
                                            <div class="cart__col-6" style="font-weight: bold; color: red; font-size: 20px;">Tổng tiền:</div>
                                            <div class="text-right cart__totle" id="total-price"><?= number_format($total_price, 0, ',', '.') ?>₫</div>
                                        </div>
                                    </div>
                                    <div class="cart__btn-proceed-checkout-dt">
                                        <form action="cart-pay.php" method="post">
                                            <input type="hidden" name="total_price" value="<?= $total_price; ?>">
                                            <button style='width: 150px;' class="custom-button" type="submit">Thanh toán</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>
    <!-- FOOTER -->
    <?php
        require "footer.php";
    ?>
</body>
<script>
    function confirmDelete(productId) {
        if (confirm("Bạn có chắc chắn muốn xóa sản phẩm này khỏi giỏ hàng không?")) {
            deleteItem(productId);
            }
    }

    function deleteItem(productId) {
        const xhr = new XMLHttpRequest();
        xhr.open('POST', 'shopping-cart-ajax.php', true);
        xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
        xhr.onload = function() {
            if (xhr.status === 200) {
                window.location.reload();
            } else {
                console.error('Lỗi khi xóa sản phẩm');
            }
        };
        xhr.send('productId=' + productId);
    }

    function decreaseQuantity(productId, price) {
        const quantityInput = document.getElementById('quantity_' + productId);
        if (parseInt(quantityInput.value) > 1) {
            quantityInput.value = parseInt(quantityInput.value) - 1;
            updateTotal(productId, price, quantityInput.value);
            updateTotalPrice(); // Cập nhật tổng tiền khi giảm số lượng
        }
    }

    function increaseQuantity(productId, price) {
        const quantityInput = document.getElementById('quantity_' + productId);
        quantityInput.value = parseInt(quantityInput.value) + 1;
        updateTotal(productId, price, quantityInput.value);
        updateTotalPrice(); // Cập nhật tổng tiền khi tăng số lượng
    }

    function updateTotal(productId, price, quantity) {
        const totalElement = document.getElementById('total_' + productId);
        const total = parseInt(price) * parseInt(quantity);
        totalElement.textContent = total.toLocaleString('vi-VN') + '₫';
    }

    function updateTotalPrice() {
        let totalPrice = 0;
        document.querySelectorAll('[id^="total_"]').forEach(function(element) {
            totalPrice += parseInt(element.textContent.replace('₫', '').replace(/\./g, ''));
        });
        document.getElementById('total-price').textContent = totalPrice.toLocaleString('vi-VN') + '₫';
    }
</script>
</html>
